/*
 * ImageSizeChanger
 * http://blog.remora.cx/2010/04/image-size-changer.html
 *
 * @version
 * 1.0.0 (April 6 2010)
 *
 * @copyright
 * Copyright (C) 2010 delphinus <delphinus@remora.cx>
 */
if ( ! window.ImageSizeChanger ) var ImageSizeChanger = function() {
var isc = {
    // configuration
    config: {
        /* Resize image width to
         * ( portraitWidth or landscapeWidth ) - margin.
         * For iPhone, it makes 300px or 460px.
         */
        margin: 20
        ,portraitWidth: 320
        ,landscapeWidth: 480
    }
    ,items: null
    ,getItems: function(){
        if ( ! isc.items ) isc.items = function() {
            var m, i
                ,images = document.getElementsByTagName( "img" )
                ,items = new Array()
            ;
            for ( i = 0; i < images.length; i++ ) {
                m = images[ i ];
                items.push( {
                    originalWidth: m.width
                    ,originalHeight: m.height
                    ,img: m
                } );
            }
            return items;
        }();
        return isc.items;
    }
    ,setSize: function() {
        var w, h, m, i
            ,items = isc.getItems()
            ,config = isc.config
            ,maxWidth = Math.abs( window.orientation ) === 90
                ? config.landscapeWidth - config.margin
                : config.portraitWidth - config.margin
        ;
        for ( i = 0; i < items.length; i++ ) {
            m = items[ i ];
            w = m.originalWidth;
            h = m.originalHeight;
            if ( w > maxWidth ) {
                m.img.width = maxWidth;
                m.img.height = h * maxWidth / w;
            }
        }
    }
    ,set: function() {
        var f = isc.setSize;
        window.addEventListener( "load", f, false );
        window.addEventListener( "orientationchange", f, false );
    }
};
return isc;
}();
