(function($){
	$.fadeRollover = function(option){
		var conf = $.extend({
			selector: '.imgover',
			attachStr: '_on',
			fadeTime: 400
		}, option)

		var targetImgs = $(conf.selector).not('[src*=' + conf.attachStr + '.]');
		targetImgs.each(function(){
			this.rollOverImg = new Image();
			this.rollOverImg.src = $(this).attr('src').replace(new RegExp('(\.gif|\.jpg|\.png)$'), conf.attachStr + '$1');
			$(this.rollOverImg).css({position: 'absolute', opacity: 0});
			$(this).before(this.rollOverImg);
			$(this.rollOverImg).hover(function(){
				$(this).animate({opacity: 1}, {duration: conf.fadeTime, queue: false});
			},
			function(){
				$(this).animate({opacity: 0}, {duration: conf.fadeTime, queue: false});
			});
		});
	};
})(jQuery);